<?php
/**
 * Created by PhpStorm.
 * User: yannick
 * Date: 15/09/2015
 * Time: 08:32
 */

namespace AlloCine\I18NBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Symfony\Component\HttpFoundation\File\File;
use AlloCine\I18NBundle\Translation\Loco;

class LocoExportCommand extends ContainerAwareCommand
{
    /**
     * {@inheritsDoc}
     */

    public function configure()
    {
        $this
            ->setName('translation:loco:export')
            ->setDescription('Export all translation from Loco.')
        ;
    }

    public function execute(InputInterface $input, OutputInterface $output)
    {
        $output = new SymfonyStyle($input, $output);
        $path   = $this->getContainer()->getParameter('translation.ui.path');

        /** @var Loco $loco */

        $loco = $this->getContainer()->get('loco');

        $tags    = $loco->getTags();
        $locales = $loco->getLocales();

        foreach ($locales as $locale => $realLocale) {
            foreach ($tags as $tag) {
                $export   = $loco->export($realLocale, $tag);

                try {
                    $filename = sprintf('%s/%s.%s.xlf', $path, $tag, $locale);
                    $file = new File($filename);
                } catch (\Exception $e) {
                    $filename = sprintf('%s/%s.%s.xlf', $path, $tag, $realLocale);
                    $file = new File($filename);
                }

                $output->text($filename);

                $file->openFile('w')->fwrite($export);
            }
        }

    }
}
