<?php

namespace AlloCine\I18NBundle\Command;

use AppBundle\Console\AllocineStyle;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use AlloCine\I18NBundle\Model\TranslationMessage;

class AddCommand extends ContainerAwareCommand
{
    /**
     * @var AllocineStyle
     */
    private $io;

    /**
     * {@inheritsDoc}
     */
    public function configure()
    {
        $this
            ->setName('translation:add')
            ->setDescription('Add a new translation string.')
        ;
    }

    /**
     * {@inheritsDoc}
     */
    public function execute(InputInterface $input, OutputInterface $output)
    {
        $this->io = new AllocineStyle($input, $output);
        $manager  = $this->getContainer()->get('allocine.translation.manager');
        $defaultLocale = $this->getContainer()->getParameter('translation.defaut.locale');

        $locales = $manager->getLocales();
        asort($locales);
        $locales = array_values($locales);

        $domain = $this->io->autocomplete('Please enter the domain of the translation', 'messages', null, $manager->getAvailableDomains());
        $key    = $this->io->ask('Please enter the key of the translation');
        $value  = $this->io->ask(sprintf('Please enter the "%s" translation', $defaultLocale));

        $message = new TranslationMessage($key, $value);
        $manager->saveDomain($manager->getCatalogue($defaultLocale)->getDomain($domain)->add($message));

        while ($this->io->confirm('Do you wish to add another translation for this key ?', false)) {
            $locale = $this->io->choice('Please choose a locale', $locales, $defaultLocale);
            $value  = $this->io->ask(sprintf('Please enter the "%s" translation', $locale));

            $manager->saveDomain($manager->getCatalogue($locale)->getDomain($domain)->add(new TranslationMessage($key, $value)));
        }
    }
}
