<?php

namespace AlloCine\I18NBundle\Tests\Translation;

use AlloCine\I18NBundle\Translation\LocoFormatter;
use Symfony\Component\Finder\SplFileInfo;

/**
 * Description of LocoFormatterTest
 *
 * @author Xavier HAUSHERR <xhausherr@allocine.fr>
 */
class LocoFormatterTest extends \PHPUnit_Framework_TestCase
{
    public function testFormat()
    {
        $xlf1 = __DIR__ .  '/Resources/test.fr_FR.xlf';
        $xlf2 = __DIR__ .  '/Resources/test.fr_FR_loco.xlf';

        $file1 = new SplFileInfo($xlf1, $xlf1, $xlf1);
        $file2 = new SplFileInfo($xlf2, $xlf2, $xlf2);

        $this->assertEquals(LocoFormatter::format($file1->getContents()), $file2->getContents());
    }

    public function testUnformat()
    {
        $xlf1 = __DIR__ .  '/Resources/test.fr_FR.xlf';
        $xlf2 = __DIR__ .  '/Resources/test.fr_FR_loco.xlf';

        $file1 = new SplFileInfo($xlf1, $xlf1, $xlf1);
        $file2 = new SplFileInfo($xlf2, $xlf2, $xlf2);

        $this->assertEquals(LocoFormatter::unformat($file2->getContents()), $file1->getContents());
    }
}
