<?php

namespace AlloCine\I18NBundle\Translation;

/**
 * LocoFormatter
 *
 * @author Xavier HAUSHERR <xhausherr@allocine.fr>
 */
class LocoFormatter
{
    /**
     * Missing translation prefixer
     */
    const PREFIX = 'missing__';

    /**
     * Remove <target> with missing translations
     * @param string $content
     * @return string
     */
    public static function format($content)
    {
        return preg_replace(
            '#<target>' . self::PREFIX . '[^<]+</target>#',
            '<target></target>',
            $content
        );
    }

    /**
     * Add prefix target when target is empty
     * @param string $content
     * @return string
     */
    public static function unformat($content)
    {
        return preg_replace(
            '#(<source>([^<]+)</source>[^<]+)<target></target>#m',
            '$1<target>' . self::PREFIX .'$2</target>',
            $content
        );
    }
}
