<?php

declare(strict_types=1);

use Rector\Config\RectorConfig;
use Rector\Symfony\Set\SymfonySetList;

return RectorConfig::configure()
    ->withPaths([
        __DIR__ . '/Command',
        __DIR__ . '/DependencyInjection',
        __DIR__ . '/Extractor',
        __DIR__ . '/Form',
        __DIR__ . '/Model',
        __DIR__ . '/Tests',
        __DIR__ . '/Translation',
    ])
    ->withPhpSets(true)
    ->withTypeCoverageLevel(0)
    ->withDeadCodeLevel(0)
    ->withSets([SymfonySetList::SYMFONY_64])
    ->withCodeQualityLevel(0);
