<?php

namespace AlloCine\I18NBundle\Form\Type;

use AlloCine\I18NBundle\Model\TranslationMessage;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;
use Symfony\Component\OptionsResolver\OptionsResolver;

class TranslationMessageType extends AbstractType
{
    /**
     * {@inheritsDoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('value');
    }

    /**
     * {@inheritsDoc}
     */
    public function buildView(FormView $view, FormInterface $form, array $options)
    {
        $view->vars['label'] = $form->getData()->getKey();
    }

    /**
     * {@inheritsDoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(['data_class' => TranslationMessage::class]);
    }
}
