<?php

namespace AlloCine\I18NBundle\Command;

use AlloCine\I18NBundle\Translation\Manager;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Translation\Writer\TranslationWriter;

/**
 * Description of NormalizeTranslationsCommand
 *
 * @author Xavier HAUSHERR <xhausherr@allocine.fr>
 */
class NormalizeTranslationsCommand extends ContainerAwareCommand
{
    /**
     * @var TranslationWriter
     */
    private $writer;

    /**
     * @var Manager
     */
    private $manager;

    public function __construct(TranslationWriter $writer, Manager $manager)
    {
        $this->writer = $writer;
        $this->manager = $manager;
        parent::__construct();
    }

    /**
     * {@inheritsDoc}
     */
    public function configure()
    {
        $this
            ->setName('translation:normalize')
            ->setDescription('Normalize xlf translation files.')
        ;
    }

    /**
     * {@inheritsDoc}
     */
    public function execute(InputInterface $input, OutputInterface $output)
    {
        $output->writeln('Normalize translation keys for known brands.');

        foreach ($this->getContainer()->getParameter('translation.ui.locales') as $locale) {
            $output->writeln(sprintf('<comment>Normalize %s.</comment>', $locale));
            $this->doExecute($locale);
        }

        $output->writeln('<info>Normalize complete.</info>');
    }

    /**
     * @param string   $locale
     * @param string[] $brands
     */
    private function doExecute($locale)
    {
        $path   = $this->getContainer()->getParameter('translation.ui.path');

        $catalogue = $this->manager->getCatalogue($locale);

        $this->writer->disableBackup();
        $this->writer->write($catalogue, 'xlf', [
            'path'           => $path,
            'default_locale' => $this->getContainer()->getParameter('translation.defaut.locale')
        ]);
    }
}
