<?php

namespace AlloCine\GraphClient\Bundle\Twig\Extension;

class GraphExtension extends \Twig_Extension
{
    /**
     * {@inheritsDoc}
     */
    public function getFilters()
    {
        return [
            new \Twig_SimpleFilter('graph_string_criteria', [$this, 'escapeStringToCriteria'])
        ];
    }

    /**
     * @param string $criteria
     *
     * @return string
     */
    public function escapeStringToCriteria($criteria): string
    {
        return sprintf('"%s"', $criteria);
    }
}
