<?php

namespace AlloCine\GraphClient\Bundle\DependencyInjection;

use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Extension\PrependExtensionInterface;
use Symfony\Component\DependencyInjection\Loader;

class GraphClientExtension extends Extension implements PrependExtensionInterface
{
    /**
     * @var Configuration
     */
    private $configuration;

    /**
     * @var array
     */
    private $config;

    /**
     * @inheritdoc
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yml');

        if (empty($this->config['client'])) {
            $container->removeDefinition('allocine.graph_client.bridge');
            $container->removeDefinition('allocine.graph_client.cache_queries');
        } else {
            $container->getDefinition('allocine.graph_client.bridge')
                ->setArgument(5, $this->config['client']['username'])
                ->setArgument(6, $this->config['client']['application_key']);

            $container->getDefinition('allocine.graph_client.logger')
                ->setArgument(0, $this->config['client']['logging_enabled']);

            if (!empty($this->config['client']['coverage'])) {
                $container->getDefinition('allocine.graph_client.coverage')
                    ->replaceArgument(0, $this->config['client']['coverage']['enabled'])
                    ->replaceArgument(1, $this->config['client']['coverage']['absolute_limit'])
                    ->replaceArgument(2, $this->config['client']['coverage']['relative_limit']);
            }

            $container->setParameter('allocine.graph_client.client.host', $this->config['client']['host']);
        }

        $container->getDefinition('allocine.graph_client.warmer')
            ->setArgument(1, $this->config['sources']['paths'])
            ->setArgument(2, $this->config['sources']['extension']);
    }

    /**
     * @inheritdoc
     */
    public function prepend(ContainerBuilder $container)
    {
        $bundles = $container->getParameter('kernel.bundles');
        $this->configuration = new Configuration($container->getParameter('kernel.root_dir'));
        $configs = $container->getExtensionConfig($this->getAlias());
        $this->config = $this->processConfiguration($this->configuration, $configs);

        if (!empty($bundles['CsaGuzzleBundle']) && !empty($this->config['client'])) {
            $extension = $container->getExtension('csa_guzzle');
            $config = [
                'clients' =>
                    ['graph' =>
                         ['config' =>
                              ['base_uri' => $this->config['client']['host']]
                         ]
                    ]
            ];
            $container->prependExtensionConfig($extension->getAlias(), $config);
        }
    }
}
