<?php

namespace AlloCine\GraphClient\CoverageChecker\Error;

use AlloCine\GraphClient\CoverageChecker\ArrayWrapper;

class CoverageError
{
    /**
     * @var string
     */
    private $message;

    /**
     * @var string
     */
    private $path;

    /**
     * @param string $message
     * @param string $path
     */
    public function __construct(string $message, string $path)
    {
        $this->message = $message;
        $this->path = $path;
    }

    /**
     * @param ArrayWrapper $wrapper
     * @param float        $coveredRatio
     *
     * @return CoverageError
     */
    public static function lowCoverageRatio(ArrayWrapper $wrapper, float $coveredRatio): CoverageError
    {
        if ($wrapper->getPath()) {
            return new CoverageError(
                sprintf('Array at path "%s" has a too low coverage ratio (%d%%).', $wrapper->getPath(), $coveredRatio),
                $wrapper->getPath()
            );
        }

        return new CoverageError(
            sprintf('Root array has a too low coverage ratio (%d%%).', $coveredRatio),
            $wrapper->getPath()
        );
    }

    /**
     * @param ArrayWrapper $wrapper
     * @param int          $uncovered
     *
     * @return CoverageError
     */
    public static function tooMuchUncovered(ArrayWrapper $wrapper, int $uncovered): CoverageError
    {
        if ($wrapper->getPath()) {
            return new CoverageError(
                sprintf(
                    'Array at path "%s" has too much uncovered data (%d serialized bytes).',
                    $wrapper->getPath(),
                    $uncovered
                ),
                $wrapper->getPath()
            );
        }

        return new CoverageError(
            sprintf('Root array has too much uncovered data (%d serialized bytes).', $uncovered),
            $wrapper->getPath()
        );
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @return string
     */
    public function getPath()
    {
        return $this->path;
    }
}
