<?php

namespace Tests\AlloCine\GraphClient\Bundle\Cache;

use AlloCine\GraphClient\Bundle\Cache\GraphApiCacheWarmer;
use Symfony\Component\Cache\Adapter\FilesystemAdapter;
use Symfony\Component\Cache\Adapter\PhpArrayAdapter;

class GraphApiCacheWarmerTest extends \PHPUnit_Framework_TestCase
{
    public function testInit()
    {
        $cacheDir = __DIR__ . '/../Resources/cache/queries.php';
        $pool = new FilesystemAdapter();
        $adapter = new PhpArrayAdapter($cacheDir, $pool);
        $service = new GraphApiCacheWarmer($adapter, [__DIR__ . '/../Resources/graph/'], '.graphql');
        $service->warmUp('');

        $this->assertSame(file_get_contents(__DIR__ . '/../Resources/graph/testReal.graphql'), $adapter->getItem('testReal')->get());
        $this->assertSame(file_get_contents(__DIR__ . '/../Resources/graph/fragments/realFragment.graphql'), $adapter->getItem('realFragment')->get());
        $this->assertNull($adapter->getItem('noReal')->get());
        $this->assertNull($adapter->getItem('noRealFragment')->get());
    }
}
