<?php

namespace AlloCine\GraphClient\Bundle\Cache;

use Symfony\Component\Cache\Adapter\PhpArrayAdapter;
use Symfony\Component\Finder\Finder;
use Symfony\Component\Finder\SplFileInfo;
use Symfony\Component\HttpKernel\CacheWarmer\CacheWarmerInterface;

class GraphApiCacheWarmer implements CacheWarmerInterface
{
    /**
     * @var PhpArrayAdapter
     */
    private $cache;

    /**
     * @var array
     */
    private $sources;

    /**
     * @var string
     */
    private $extension;

    /**
     * @var array
     */
    private $queries = [];

    /**
     * @param PhpArrayAdapter $cache
     * @param array           $sources
     * @param string          $extension
     */
    public function __construct(PhpArrayAdapter $cache, array $sources, string $extension)
    {
        $this->cache = $cache;
        $this->sources = $sources;
        $this->extension = $extension;
        $this->init();
    }

    private function init()
    {
        $finder = new Finder();
        $queries = $finder->files()->in($this->sources);
        $extension = str_replace('.', '', $this->extension);

        /** @var SplFileInfo $query */
        foreach ($queries as $query) {
            if ($query->getExtension() === $extension) {
                $queryName = str_replace($this->extension, '', $query->getFilename());
                $this->queries[$queryName] = $query->getContents();
            }
        }
    }

    /**
     * {@inheritsDoc}
     */
    public function warmUp($cacheDir)
    {
        $this->cache->warmUp($this->queries);
    }

    /**
     * {@inheritsDoc}
     */
    public function isOptional()
    {
        return false;
    }
}
