How to install the project
==========================

[Back to menu](../readme.md)

First you need to add satis to your `composer.json` file like this : 
```json
    //Some configurations  
    "repositories": [
        //Some repositories
        {
            "type": "composer",
            "url": "https://satis.allocine.net"
        }
    ],
```
After, you need to add the project to your composer : `composer require allocine/graph-client dev-master`

And add the bundle to you `AppKernel.php` located in `your/project/folder/app/`

```php
 
    public function registerBundles()
    {
        $bundles = array(
            //Some bundles
            new Lexik\Bundle\JWTAuthenticationBundle\LexikJWTAuthenticationBundle(), //This is required for the connexion
            new AlloCine\GraphClient\Bundle\GraphClientBundle(),
            new Csa\Bundle\GuzzleBundle\CsaGuzzleBundle(), //You must load this bundle after Graph Client bundle
        );
        
        return $bundles;
    }
```

That all. Now you need to [configure](./bundle-configuration.md) it
