How to configure the bundle
===========================

[Back to installation](./bundle-installation.md)

This is the available configuration for the bundle

config.yml
```yml
graph_client:
    sources:
        paths: [] # By default it's [%kernel_root_dir%/Resources/graphql"]
        extension: "" # By default it's ".graphql"
    client: #If set, all elements must been configured 
        host: "" # The host
        username: "" # The username
        application_key: "" # The jwt key
        logging_enabled: false # If you want to log queries to see in the debug toolbar
        coverage:
            enabled: false # If you want to cover, put to true
            absolute_limit: 0 # The data byte length uncovered limit. At default to 0 to show if any element is not use
            relative_limit: 100 # The total ratio cover. At default to 100 to have 100% data used
```

config_dev.yml
```yml
graph_client:
    client: 
        logging_enabled: true
```

After configuration, for test mod you need to add the CSAGuzzle header blacklist

config_test.php
```yml
csa_guzzle:
    mock:
        request_headers_blacklist: 
            #other black list
            - authorization
```

No you can use the bundle without problems. If you want to change the queries cache adapter, 
it's simple to do [here](./bundle-query-service.md)

If you want to directly use the service, you can check the [usage doc](./bundle-usage.md)
