<?php

declare(strict_types=1);

namespace Tests\AlloCine\GraphClient\Bundle\Parser;

use AlloCine\GraphClient\Bundle\Parser\QueryParser;
use Exception;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Finder\Finder;
use Symfony\Component\Finder\SplFileInfo;

class QueryParserTest extends TestCase
{
    private array $sources = [
        'queries' => __DIR__ . '/../Resources/graph/queries/',
        'fragments' => __DIR__ . '/../Resources/graph/fragments/',
    ];

    /**
     * @var array<string, string>
     */
    private array $queries = [];

    /**
     * @var array<string, string>
     */
    private array $fragments = [];

    /**
     * @throws Exception
     */
    public function setUp(): void
    {
        $this->init();
    }

    /**
     * @throws Exception
     */
    public function testParseQueryWith2Fragments(): void
    {
        $service = new QueryParser();
        $query =
            <<<GRAPHQL
{
    testTwoReal (test: 10){
        ...realFragment
        ...realFragment
    }
}
GRAPHQL;
        $result = $service->setFragments($this->fragments)->parseQuery($query);
        $this->assertSame($query . ' ' . $this->fragments['realFragment'], $result);

    }

    /**
     * @throws Exception
     */
    public function testParseQueryReal(): void
    {
        $service = new QueryParser();
        $result = $service->setFragments($this->fragments)->parseQuery($this->queries['testReal']);
        $this->assertSame($this->queries['testReal'], $result);

    }

    /**
     * @throws Exception
     */
    private function init(): void
    {
        $this->storedQueries('queries');
        $this->storedQueries('fragments');
    }

    private function storedQueries(string $arrayName): void
    {
        $finder = new Finder();
        $templates = $finder->files()->in($this->sources[$arrayName]);
        $extension = str_replace('.', '', 'graphql');
        /** @var SplFileInfo $template */
        foreach ($templates as $template) {
            if ($template->getExtension() === $extension) {
                $fragmentName = str_replace('.graphql', '', $template->getFilename());
                if ($arrayName === 'queries') {
                    $this->queries[$fragmentName] = $template->getContents();
                } else {
                    $this->fragments[$fragmentName] = $template->getContents();
                }
            }
        }
    }
}
