<?php

declare(strict_types=1);

namespace AlloCine\GraphClient\CoverageChecker\Error;

use AlloCine\GraphClient\CoverageChecker\ArrayWrapper;

class CoverageError
{
    public function __construct(private readonly string $message, private readonly string $path)
    {
    }

    public static function lowCoverageRatio(ArrayWrapper $wrapper, float $coveredRatio): CoverageError
    {
        if (!empty($wrapper->getPath())) {
            return new CoverageError(
                sprintf('Array at path "%s" has a too low coverage ratio (%d%%).', $wrapper->getPath(), $coveredRatio),
                $wrapper->getPath()
            );
        }

        return new CoverageError(
            sprintf('Root array has a too low coverage ratio (%d%%).', $coveredRatio),
            $wrapper->getPath()
        );
    }

    public static function tooMuchUncovered(ArrayWrapper $wrapper, int $uncovered): CoverageError
    {
        if (!empty($wrapper->getPath())) {
            return new CoverageError(
                sprintf(
                    'Array at path "%s" has too much uncovered data (%d serialized bytes).',
                    $wrapper->getPath(),
                    $uncovered
                ),
                $wrapper->getPath()
            );
        }

        return new CoverageError(
            sprintf('Root array has too much uncovered data (%d serialized bytes).', $uncovered),
            $wrapper->getPath()
        );
    }

    public function getMessage(): string
    {
        return $this->message;
    }

    public function getPath(): string
    {
        return $this->path;
    }
}
