<?php

declare(strict_types=1);

namespace AlloCine\GraphClient\CoverageChecker\Checker;

use AlloCine\GraphClient\CoverageChecker\ArrayWrapper;
use AlloCine\GraphClient\CoverageChecker\Error\CoverageError;

class RelativeChecker extends Checker
{
    public function __construct(private readonly int $threshold = 100)
    {
    }

    public function getValue(ArrayWrapper $wrapper): int
    {
        $coverage = $wrapper->getCoverage();

        return 100 * $coverage['covered'] / ($coverage['uncovered'] + $coverage['covered']);
    }

    public function check(ArrayWrapper $wrapper): array
    {
        $errors = [];

        $wrapper->silkTouchIterate(function ($item) use (&$errors): void {
            if (!$item instanceof ArrayWrapper) {
                return;
            }

            $errors = array_merge($errors, $this->check($item));
        });

        $coverage = $wrapper->getCoverage();
        $coveredRatio = 100 * $coverage['covered'] / ($coverage['uncovered'] + $coverage['covered']);

        if ($coveredRatio < $this->threshold) {
            $errors[] = CoverageError::lowCoverageRatio($wrapper, $coveredRatio);
        }

        return $errors;
    }
}
