<?php

declare(strict_types=1);

namespace AlloCine\GraphClient\CoverageChecker\Checker;

use AlloCine\GraphClient\CoverageChecker\ArrayWrapper;

class CheckerChain extends Checker
{
    public function __construct(private readonly array $checkers)
    {
    }

    public function getValue(ArrayWrapper $wrapper): int
    {
        return 0;
    }

    public function check(ArrayWrapper $wrapper): array
    {
        $errors = [];

        foreach ($this->checkers as $checker) {
            foreach ($checker->check($wrapper) as $error) {
                $errors[] = $error;
            }
        }

        return $errors;
    }
}
