<?php

declare(strict_types=1);

namespace AlloCine\GraphClient\CoverageChecker\Checker;

use AlloCine\GraphClient\CoverageChecker\ArrayWrapper;
use AlloCine\GraphClient\CoverageChecker\Error\CoverageError;

class AbsoluteChecker extends Checker
{
    public function __construct(private readonly int $threshold = 0)
    {
    }

    public function getValue(ArrayWrapper $wrapper): int
    {
        return $wrapper->getCoverage()['uncovered'];
    }

    public function check(ArrayWrapper $wrapper): array
    {
        $errors = [];

        $wrapper->silkTouchIterate(function ($item) use (&$errors): void {
            if (!($item instanceof ArrayWrapper)) {
                return;
            }

            $errors = array_merge($errors, $this->check($item));
        });

        $coverage = $wrapper->getCoverage();

        if ($coverage['uncovered'] > $this->threshold) {
            $errors[] = CoverageError::tooMuchUncovered($wrapper, $coverage['uncovered']);
        }

        return $errors;
    }
}
