<?php

declare(strict_types=1);

namespace AlloCine\GraphClient\Bundle\Twig\Extension;

use Override;
use Twig\Extension\AbstractExtension;
use Twig\TwigFilter;

class GraphExtension extends AbstractExtension
{
    #[Override]
    public function getFilters(): array
    {
        return [
            new TwigFilter('graph_string_criteria', $this->escapeStringToCriteria(...))
        ];
    }

    public function escapeStringToCriteria(string $criteria): string
    {
        return sprintf('"%s"', $criteria);
    }
}
