<?php

declare(strict_types=1);

namespace AlloCine\GraphClient\Bundle\Client;

use stdClass;
use AlloCine\GraphClient\CoverageChecker\ArrayWrapper;
use AlloCine\GraphClient\CoverageChecker\Checker\AbsoluteChecker;
use AlloCine\GraphClient\CoverageChecker\Checker\RelativeChecker;

class GraphCoverage
{
    private array $storage = [];

    public function __construct(
        private readonly bool $enabled,
        private readonly int $absoluteLimit,
        private readonly int $relativeLimit
    ) {
    }

    public function transformToCoverage(stdClass $data): stdClass|ArrayWrapper
    {
        if ($this->enabled) {
            $id = count($this->storage);
            $data = new ArrayWrapper($data);
            $this->storage[$id] = $data;
        }

        return $data;
    }

    public function getResults(): array
    {
        $results = [];

        foreach ($this->storage as $storage) {
            $results[] = [
                'absolute' => (new AbsoluteChecker($this->absoluteLimit))->check($storage),
                'relative' => (new RelativeChecker($this->relativeLimit))->check($storage),
            ];
        }

        return $results;
    }

    public function getTotalAbsolute(): int
    {
        $total = 0;
        foreach ($this->storage as $storage) {
            $total += (new AbsoluteChecker($this->absoluteLimit))->getValue($storage);
        }

        return $total;
    }

    public function getTotalRelative(): int
    {
        $total = 0;
        foreach ($this->storage as $storage) {
            $total += (new RelativeChecker($this->absoluteLimit))->getValue($storage);
        }

        return $total;
    }

    public function isEnabled(): bool
    {
        return $this->enabled;
    }
}
