<?php

declare(strict_types=1);

use Rector\Config\RectorConfig;
use Rector\Set\ValueObject\LevelSetList;
use Rector\Set\ValueObject\SetList;
use Rector\Php81\Rector\ClassMethod\NewInInitializerRector;
use Rector\Php83\Rector\ClassMethod\AddOverrideAttributeToOverriddenMethodsRector;
use Rector\ValueObject\PhpVersion;

return RectorConfig::configure()
    ->withPaths([
        __DIR__ . '/src',
        __DIR__ . '/tests',
    ])
    ->withPhpVersion(PhpVersion::PHP_83)
    ->withSets([
        SetList::PHP_83,
        LevelSetList::UP_TO_PHP_83,
        SetList::CODE_QUALITY,
        SetList::DEAD_CODE,
        SetList::RECTOR_PRESET,
        SetList::TYPE_DECLARATION,
    ])
    ->withRules([
        AddOverrideAttributeToOverriddenMethodsRector::class,
        NewInInitializerRector::class,
    ])
    ->withImportNames(removeUnusedImports: true)
    ->withComposerBased(symfony: true)
    ->withAttributesSets(symfony: true)
    ;
