How to configure the bundle
===========================

[Back to installation](./bundle-installation.md)

This is the available configuration for the bundle

First you need to configure a GraphQL client for the Symfony `HttpClient`.

The client must be called `graph.http_client` for autowiring compliance reason.

```yml
# config/packages/http_client.yml
framework:
    http_client:
        default_options:
            headers:
                User-Agent: 'www/%kernel.environment%-%git_commit%'
                Content-Type: 'application/json'
        scoped_clients:
            graph.http_client:
                base_uri: # The API host
                auth_bearer: # The token generated by mutation on the api
                timeout: # The idle timeout, defaults to the "default_socket_timeout" ini parameter.
                max_duration: # The maximum execution time for the request+response as a whole.
                headers:
                    Content-Type: 'application/json'
```

```yml
# config/packages/graph_client.yml
graph_client:
    sources:
        paths: [] # By default it's [%kernel_root_dir%/Resources/graphql"]
        extension: "" # By default it's ".graphql"
    client: #If set, all elements must been configured 
        api_uri: "" # The api uri to contact
        logging_enabled: false # If you want to log queries to see in the debug toolbar
        coverage:
            enabled: false # If you want to cover, put to true
            absolute_limit: 0 # The data byte length uncovered limit. At default to 0 to show if any element is not use
            relative_limit: 100 # The total ratio cover. At default to 100 to have 100% data used
```

```yml
# config/packages/dev/graph_client.yml
graph_client:
    client: 
        logging_enabled: true
```

The bundle is now configured. If you want to change the queries cache adapter, it's simple to do it [here](./bundle-query-service.md)

If you want to directly use the service, you can check the [usage doc](./bundle-usage.md)
