<?php

namespace Tests\AlloCine\GraphClient\CoverageChecker\Checker;

use AlloCine\GraphClient\CoverageChecker\ArrayWrapper;
use AlloCine\GraphClient\CoverageChecker\Checker\AbsoluteChecker;
use AlloCine\GraphClient\CoverageChecker\Checker\CheckerChain;
use AlloCine\GraphClient\CoverageChecker\Checker\RelativeChecker;
use PHPUnit\Framework\TestCase;

class CheckerChainTest extends TestCase
{
    public function testCheck()
    {
        $wrapper = $this->getWrapper();
        $checkerAbsolute = new AbsoluteChecker();
        $checkerRelative = new RelativeChecker();
        $checker = new CheckerChain([$checkerAbsolute, $checkerRelative]);

        $wrapper['foobar'];

        $errors = $checker->check($wrapper);

        $this->assertSame(6, count($errors));
        $this->assertSame('Array at path "foo.bar" has too much uncovered data (10 serialized bytes).', $errors[0]->getMessage());
        $this->assertSame('Array at path "foo" has too much uncovered data (10 serialized bytes).', $errors[1]->getMessage());
        $this->assertSame('Root array has too much uncovered data (10 serialized bytes).', $errors[2]->getMessage());
        $this->assertSame('Array at path "foo.bar" has a too low coverage ratio (0%).', $errors[3]->getMessage());
        $this->assertSame('Array at path "foo" has a too low coverage ratio (0%).', $errors[4]->getMessage());
        $this->assertSame('Root array has a too low coverage ratio (28%).', $errors[5]->getMessage());
    }

    public function testCheckNoErrors()
    {
        $wrapper = $this->getWrapper();
        $checkerAbsolute = new AbsoluteChecker();
        $checkerRelative = new RelativeChecker();
        $checker = new CheckerChain([$checkerAbsolute, $checkerRelative]);

        $wrapper['foobar'];
        $wrapper['foo']['bar'][0];

        $errors = $checker->check($wrapper);

        $this->assertSame(0, count($errors));
    }

    /**
     * @return ArrayWrapper
     */
    private function getWrapper(): ArrayWrapper
    {
        return new ArrayWrapper([
            'foo' => [
                'bar' => ['baz']
            ],
            'foobar' => 1
        ]);
    }
}
