<?php

namespace AlloCine\GraphClient\Bundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{
    /**
     * @var string
     */
    private $kernelRootDir;

    /**
     * @param string $kernelRootDir
     */
    public function __construct(string $kernelRootDir)
    {
        $this->kernelRootDir = $kernelRootDir;
    }

    /**
     * @inheritdoc
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();

        $treeBuilder
            ->root('graph_client')
                ->children()
                    ->arrayNode('sources')
                        ->children()
                            ->arrayNode('paths')
                                ->prototype('scalar')->end()
                                ->isRequired()
                                ->cannotBeEmpty()
                                ->defaultValue(["{$this->kernelRootDir}/Resources/graphql"])
                                ->info("The array contains the graphql file path sources ")
                            ->end()
                            ->scalarNode('extension')
                                ->isRequired()
                                ->cannotBeEmpty()
                                ->defaultValue('.graphql')
                                ->info("The generic graphql file extension")
                            ->end()
                        ->end()
                    ->end()
                    ->arrayNode('client')
                        ->children()
                            ->scalarNode('host')
                                ->isRequired()
                                ->cannotBeEmpty()
                                ->info("The client host uri")
                            ->end()
                            ->scalarNode('username')
                                ->isRequired()
                                ->cannotBeEmpty()
                                ->info("The client username login")
                            ->end()
                            ->scalarNode('application_key')
                                ->isRequired()
                                ->cannotBeEmpty()
                                ->info("The client api key")
                            ->end()
                            ->scalarNode('api_uri')
                                ->isRequired()
                                ->cannotBeEmpty()
                                ->info("The api uri to contact")
                            ->end()
                            ->booleanNode('logging_enabled')
                                ->isRequired()
                                ->defaultFalse()
                                ->info("Set true to log graph queries in profiler")
                            ->end()
                            ->arrayNode('coverage')
                                ->children()
                                    ->booleanNode('enabled')
                                        ->isRequired()
                                        ->defaultFalse()
                                        ->info("Set true to log the graphql data coverage")
                                    ->end()
                                    ->integerNode('absolute_limit')
                                        ->defaultValue(0)
                                        ->info(
                                            "The data byte length uncovered limit. 
                                            At default to 0 to show if any element is not use"
                                        )
                                    ->end()
                                    ->integerNode('relative_limit')
                                        ->defaultValue(100)
                                        ->info("The total ratio cover. At default to 100 to have 100% data used")
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
