<?php

namespace AlloCine\GraphClient\Bundle\Client;

class Request
{
    private ?string $queryName;
    private array $variables;
    private int $ttl;
    private ?string $identifier;
    private $callback;

    public function __construct(?string $queryName = null, array $variables = [], ?string $identifier = null, int $ttl = 600, ?callable $callback = null)
    {
        $this->queryName = $queryName;
        $this->variables = $variables;
        $this->identifier = $identifier;
        $this->ttl = $ttl;
        $this->callback = $callback;
    }

    public function getQueryName(): ?string
    {
        return $this->queryName;
    }

    public function getVariables(): array
    {
        return $this->variables;
    }

    public function getTtl(): int
    {
        return $this->ttl;
    }

    public function getIdentifier(): ?string
    {
        return $this->identifier;
    }

    public function getCallback(): ?callable
    {
        return $this->callback;
    }

    public function setQueryName(?string $queryName): self
    {
        $this->queryName = $queryName;

        return $this;
    }

    public function setVariables(array $variables): self
    {
        $this->variables = $variables;
        return $this;
    }

    public function setTtl(int $ttl): self
    {
        $this->ttl = $ttl;
        return $this;
    }

    public function setIdentifier(?string $identifier): self
    {
        $this->identifier = $identifier;
        return $this;
    }

    public function setCallback(?callable $callback): self
    {
        $this->callback = $callback;
        return $this;
    }

    /**
     * Execute the callback if it exists
     *
     * @param mixed $result The result to pass to the callback
     * @param bool $fromCache Whether the result comes from cache
     * @return mixed The result of the callback, or the original result if no callback
     */
    public function executeCallback($result, bool $fromCache = false)
    {
        if ($this->callback !== null) {
            return call_user_func($this->callback, $result, $this, $fromCache);
        }

        return $result;
    }

    /**
     * Check if this request has a callback
     *
     * @return bool
     */
    public function hasCallback(): bool
    {
        return $this->callback !== null;
    }
}
