<?php

declare(strict_types=1);

namespace AlloCine\GraphClient\Bundle\Client;

class GraphApiLogger
{
    private array $storage = [];

    public function __construct(private readonly bool $enabled = true)
    {
    }

    public function start(string $query): int
    {
        if (!$this->enabled) {
            return -1;
        }

        $id = count($this->storage);

        $this->storage[$id] = ['query' => json_decode($query, false, 512, JSON_THROW_ON_ERROR), 'start_time' => microtime(true)];

        return $id;
    }

    public function stop(int $id, string $result): void
    {
        if (!$this->enabled) {
            return;
        }

        $result = json_decode($result, false, 512, JSON_THROW_ON_ERROR);

        $this->storage[$id]['end_time'] = microtime(true);
        $this->storage[$id]['duration'] = $this->storage[$id]['end_time'] - $this->storage[$id]['start_time'];
        $this->storage[$id]['complexity'] = $result->extensions->complexity ?? null;
        unset($result->extensions->complexity);
        $this->storage[$id]['result'] = $result;
        $this->storage[$id]['payload'] = isset($result->data) ? strlen(json_encode($result->data, JSON_THROW_ON_ERROR)) / 1024 : 0;
    }

    public function getAll(): array
    {
        return array_values($this->storage);
    }

    public function isEnabled(): bool
    {
        return $this->enabled;
    }
}
