<?php

namespace AlloCine\GraphClient\Bundle\Client;

class BatchRequest
{
    /** @var Request[] */
    private array $requests = [];

    public function addRequest(Request $request): self
    {
        if ($request->getQueryName() === null) {
            throw new \InvalidArgumentException('Request queryName must be defined before adding to batch');
        }

        $this->requests[] = $request;
        return $this;
    }

    /**
     * @return Request[]
     */
    public function getRequests(): array
    {
        return $this->requests;
    }

    public function count(): int
    {
        return count($this->requests);
    }

    public function isEmpty(): bool
    {
        return empty($this->requests);
    }

    public function clear(): self
    {
        $this->requests = [];
        return $this;
    }

    /**
     * Get a specific request by index or identifier
     *
     * @param int|string $key Index (int) or identifier (string)
     * @return Request|null
     */
    public function getRequest(int|string $key): ?Request
    {
        // If it's an integer, use it as array index
        if (is_int($key)) {
            return $this->requests[$key] ?? null;
        }

        // If it's a string, search by identifier
        foreach ($this->requests as $request) {
            if ($request->getIdentifier() === $key) {
                return $request;
            }
        }

        return null;
    }
}
