<?php
/**
 * graph-client
 * Created by Minh-Quan TRAN on 11/10/2019
 */

namespace AlloCine\GraphClient\Bundle\Cache;


use Kevinrob\GuzzleCache\KeyValueHttpHeader;
use Psr\Http\Message\RequestInterface;

class GreedyCacheStrategy extends \Kevinrob\GuzzleCache\Strategy\GreedyCacheStrategy
{
    protected function getCacheKey(RequestInterface $request, KeyValueHttpHeader $varyHeaders = null)
    {
        if (null === $varyHeaders || $varyHeaders->isEmpty()) {
            return hash(
                'sha256',
                'greedy'.$request->getMethod().$request->getUri()
            );
        }

        $cacheHeaders = [];
        foreach ($varyHeaders as $key => $value) {
            if ($request->hasHeader($key)) {
                $cacheHeaders[$key] = $request->getHeader($key);
            }
        }

        return hash(
            'sha256',
            'greedy'.$request->getMethod().$request->getUri().json_encode($cacheHeaders).$request->getBody()
        );
    }

}
