<?php
/**
 * graph-client
 * Created by Minh-Quan TRAN on 11/10/2019
 */

namespace AlloCine\GraphClient\Bundle\Cache;


use Kevinrob\GuzzleCache\Storage\Psr6CacheStorage;
use Psr\Cache\CacheItemPoolInterface;

class CacheMiddleware
{
    /**
     * @param CacheItemPoolInterface $adapter
     * @param int                    $ttl in seconds
     * @return CacheMiddleware
     */
    public static function factory(CacheItemPoolInterface $adapter, int $ttl = 3600) {
        $middleware = new CacheMiddleware(
            new GreedyCacheStrategy(
                new Psr6CacheStorage($adapter),
                $ttl
            )
        );

        return $middleware;
    }
}
