<?php

namespace AlloCine\GraphClient\CoverageChecker\Checker;

use AlloCine\GraphClient\CoverageChecker\ArrayWrapper;

class CheckerChain extends Checker
{
    /**
     * @var Checker[]
     */
    private $checkers;

    /**
     * @param array $checkers
     */
    public function __construct(array $checkers)
    {
        $this->checkers = $checkers;
    }

    /**
     * {@inheritdoc}
     */
    public function getValue(ArrayWrapper $wrapper): int
    {
        return 0;
    }

    /**
     * {@inheritdoc}
     */
    public function check(ArrayWrapper $wrapper): array
    {
        $errors = [];

        foreach ($this->checkers as $checker) {
            $errors = array_merge($errors, $checker->check($wrapper));
        }

        return $errors;
    }
}
