<?php

namespace AlloCine\GraphClient\Bundle\Parser;

use AlloCine\GraphClient\Bundle\Exception\FileNotFoundException;
use GraphQL\Language\AST\FragmentSpreadNode;
use GraphQL\Language\AST\NodeKind;
use GraphQL\Language\Parser;
use GraphQL\Language\Visitor;

class QueryParser
{
    /**
     * @var array
     */
    private $loadedFragments = [];

    /**
     * @var array
     */
    private $fragments = [];

    /**
     * @param string $source
     *
     * @return array
     * @throws \Exception
     */
    private function getFragmentNames(string $source): array
    {
        $fragments = [];
        Visitor::visit(Parser::parse($source), [
            'leave' => [
                NodeKind::FRAGMENT_SPREAD => function (FragmentSpreadNode $node) use (&$fragments) {
                    $fragments[] = $node->name->value;
                },
            ],
        ]);

        return $fragments;
    }

    /**
     * @param $query
     *
     * @return string
     * @throws FileNotFoundException
     */
    private function recursiveAddFragments($query)
    {
        if ($matches = $this->getFragmentNames($query)) {
            foreach ($matches as $fragment) {
                if (!in_array($fragment, $this->loadedFragments)) {
                    if (!array_key_exists($fragment, $this->fragments)) {
                        throw new FileNotFoundException("The graph fragment $fragment does not exist");
                    }
                    $fragmentFile = $this->fragments[$fragment];

                    $this->loadedFragments[] = $fragment;
                    $parsedFragment = $this->recursiveAddFragments($fragmentFile);
                    $query .= ' ' . $parsedFragment;
                }
            }
        }

        return $query;
    }

    /**
     * @param array $fragments
     *
     * @return QueryParser
     */
    public function setFragments(array $fragments): QueryParser
    {
        $this->fragments = $fragments;

        return $this;
    }

    /**
     * @param string $query
     *
     * @return string
     * @throws FileNotFoundException
     */
    public function parseQuery(string $query): string
    {
        $query = $this->recursiveAddFragments($query);
        $this->loadedFragments = [];

        return $query;
    }
}
