<?php

namespace AlloCine\GraphClient\Bundle\Client;

use AlloCine\GraphClient\CoverageChecker\ArrayWrapper;
use AlloCine\GraphClient\CoverageChecker\Checker\AbsoluteChecker;
use AlloCine\GraphClient\CoverageChecker\Checker\RelativeChecker;

class GraphCoverage
{
    /**
     * @var bool
     */
    private $enabled;

    /**
     * @var int
     */
    private $absolute_limit;

    /**
     * @var int
     */
    private $relative_limit;

    /**
     * @var array
     */
    private $storage = [];

    /**
     * @param bool $enabled
     * @param int $absolute_limit
     * @param int $relative_limit
     */
    public function __construct(bool $enabled, int $absolute_limit, int $relative_limit)
    {
        $this->enabled = $enabled;
        $this->absolute_limit = $absolute_limit;
        $this->relative_limit = $relative_limit;
    }

    /**
     * @param \stdClass $data
     *
     * @return ArrayWrapper|\stdClass
     */
    public function transformToCoverage(\stdClass $data)
    {
        if ($this->enabled) {
            $id = count($this->storage);
            $data = new ArrayWrapper($data);
            $this->storage[$id] = $data;
        }

        return $data;
    }

    /**
     * @return array
     */
    public function getResults()
    {
        $results = [];

        foreach ($this->storage as $storage) {
            $results[] = [
                'absolute' => (new AbsoluteChecker($this->absolute_limit))->check($storage),
                'relative' => (new RelativeChecker($this->relative_limit))->check($storage),
            ];
        }

        return $results;
    }

    /**
     * @return int
     */
    public function getTotalAbsolute(): int
    {
        $total = 0;
        foreach ($this->storage as $storage) {
            $total += (new AbsoluteChecker($this->absolute_limit))->getValue($storage);
        }

        return $total;
    }

    /**
     * @return int
     */
    public function getTotalRelative(): int
    {
        $total = 0;
        foreach ($this->storage as $storage) {
            $total += (new RelativeChecker($this->absolute_limit))->getValue($storage);
        }

        return $total;
    }

    /**
     * @return bool
     */
    public function isEnabled(): bool
    {
        return $this->enabled;
    }
}
