<?php

namespace AlloCine\GraphClient\Bundle\Client;

use Symfony\Component\Cache\Adapter\FilesystemAdapter;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Contracts\Cache\CacheInterface;
use Symfony\Contracts\HttpClient\ResponseInterface;

class GraphClientFixturesMiddleware
{

    private string $mode;

    private CacheInterface $cache;

    function __construct(string $apiHost, string $fixturesPath, string $mode)
    {
        $this->cache = new FilesystemAdapter($this->sanitizeRedisKey($apiHost), 0, $fixturesPath);
        $this->mode = $mode;
    }

    public function getMode(): string
    {
        return $this->mode;
    }

    public function getFixture(string $method, string $url, ?array $options)
    {
        $key = $this->getKey($method, $url, $options['query']);
        $fixtureItem = $this->cache->getItem($key);

        if (!$fixtureItem->isHit()) {
            // @todo
            throw new \Exception(sprintf('missing file : %s', $key), 404);
        }

        return new Response($fixtureItem->get());
    }

    private function getKey(string $method, string $url, string $hash)
    {
        return $this->sanitizeRedisKey(sprintf('%s_%s_%s', $method, $url, $hash));
    }

    private function sanitizeRedisKey(string $key): string
    {
        return str_replace(str_split('@{}()/\:'), '_', $key);
    }

    public function setFixture(string $method, string $url, string $hash, ResponseInterface $response)
    {
        $fixtureItem = $this->cache->getItem($this->getKey($method, $url, $hash));
        $fixtureItem->set(($response->getContent()));
        return  $this->cache->save($fixtureItem);
    }


}
