<?php

namespace Tests\AlloCine\GraphClient\CoverageChecker;

use AlloCine\GraphClient\CoverageChecker\ArrayWrapper;
use PHPUnit\Framework\TestCase;

class ArrayWrapperTest extends TestCase
{
    public function testPath()
    {
        $wrapper = new ArrayWrapper([
            'foo' => [
                'bar' => ['baz']
            ]
        ]);

        $this->assertSame('', $wrapper->getPath());
        $this->assertSame('foo', $wrapper['foo']->getPath());
        $this->assertSame('foo.bar', $wrapper['foo']['bar']->getPath());
    }

    public function testCoverage()
    {
        $wrapper = new ArrayWrapper([
            'foo' => [
                'bar' => 'baz'
            ],
            'foobar' => 1
        ]);

        $this->assertSame(0, $wrapper->getCoverage()['covered']);

        $wrapper['foo']; // Access an array but none of its properties
        $this->assertSame(0, $wrapper->getCoverage()['covered']);

        $wrapper['foobar']; // Access a scalar property
        $this->assertSame(strlen(serialize(1)), $wrapper->getCoverage()['covered']); // The scalar property is used.
        $this->assertSame(strlen(serialize('baz')), $wrapper->getCoverage()['uncovered']); // The nested property is not.
    }

    public function testPathObject()
    {
        $bar = new \stdClass();
        $bar->bar = ['baz'];
        $foo = new \stdClass();
        $foo->foo = $bar;
        $wrapper = new ArrayWrapper($foo);

        $this->assertSame('', $wrapper->getPath());
        $this->assertSame('foo', $wrapper['foo']->getPath());
        $this->assertSame('foo.bar', $wrapper['foo']['bar']->getPath());
    }

    public function testCoverageObject()
    {
        $bar = new \stdClass();
        $bar->bar = ['baz'];
        $foo = new \stdClass();
        $foo->foo = $bar;
        $foo->foobar = 1;
        $wrapper = new ArrayWrapper($foo);

        $this->assertSame(0, $wrapper->getCoverage()['covered']);

        $wrapper->foo; // Access an array but none of its properties
        $this->assertSame(0, $wrapper->getCoverage()['covered']);

        $wrapper->foobar; // Access a scalar property
        $this->assertSame(strlen(serialize(1)), $wrapper->getCoverage()['covered']); // The scalar property is used.
        $this->assertSame(strlen(serialize('baz')), $wrapper->getCoverage()['uncovered']); // The nested property is not.
    }
}
