<?php

namespace AlloCine\GraphClient\Bundle\Twig\Extension;

class GraphExtension extends \Twig\Extension\AbstractExtension
{
    /**
     * {@inheritsDoc}
     */
    public function getFilters()
    {
        return [
            new \Twig\TwigFilter('graph_string_criteria', [$this, 'escapeStringToCriteria'])
        ];
    }

    /**
     * @param string $criteria
     *
     * @return string
     */
    public function escapeStringToCriteria($criteria): string
    {
        return sprintf('"%s"', $criteria);
    }
}
