<?php

namespace AlloCine\GraphClient\Bundle\Client;

class GraphCursor
{
    const CURSOR_INTERNAL_PREFIX = 'arrayconnection';

    /**
     * Given an offset in a list, returns the cursor to use as a value for
     * the graph "after" argument to paginate from this offset.
     *
     * @param int $page
     * @param int $offset
     *
     * @return null|string
     */
    public function getAfterCursor(int $page, int $offset)
    {
        if (1 !== $page) {
            return $this->encodeCursor($offset - 1);
        }

        return null;
    }

    /**
     * @param int $position
     *
     * @return string
     */
    private function encodeCursor(int $position): string
    {
        return base64_encode(sprintf('%s:%d', self::CURSOR_INTERNAL_PREFIX, $position));
    }
}
