<?php

declare(strict_types=1);

namespace AlloCine\GraphClient\Tests\Bundle\Cache;

use AlloCine\GraphClient\Bundle\Cache\GraphApiCacheWarmer;
use AlloCine\GraphClient\Bundle\Parser\QueryParser;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Cache\Adapter\FilesystemAdapter;
use Symfony\Component\Cache\Adapter\PhpArrayAdapter;

class GraphApiCacheWarmerTest extends TestCase
{
    public function testInit(): void
    {
        $cacheDir = __DIR__ . '/../Resources/cache/queries.php';
        $pool = new FilesystemAdapter();
        $adapter = new PhpArrayAdapter($cacheDir, $pool);
        $sources = ['queries' => [__DIR__ . '/../Resources/graph/queries'], 'fragments' => [__DIR__ . '/../Resources/graph/fragments']];
        $service = new GraphApiCacheWarmer($adapter, new QueryParser(), $sources, '.graphql');
        $service->warmUp('');

        $this->assertStringEqualsFile(
            __DIR__.'/../Resources/graph/queries/testReal.graphql',
            $adapter->getItem('testReal')->get()
        );
        $this->assertNull($adapter->getItem('noReal')->get());
        $this->assertNull($adapter->getItem('noRealFragment')->get());
    }
}
