<?php

declare(strict_types=1);

namespace AlloCine\GraphClient\Tests\Bundle\Client;

use AlloCine\GraphClient\Bundle\Client\GraphClientFixturesMiddleware;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Cache\Adapter\ArrayAdapter;
use Symfony\Component\HttpClient\MockHttpClient;
use Symfony\Component\HttpClient\Response\MockResponse;
use Symfony\Component\HttpFoundation\Request;

class GraphClientFixturesMiddlewareTest extends TestCase
{
    public function testSetGetFixtures(): void
    {
        //given
        $fixtureClient = new GraphClientFixturesMiddleware(
            $cache = new  ArrayAdapter(),
            'toto',
            __DIR__ . ('/toto'),
            'record'
        );

        $fakeQuery = new MockHttpClient(new MockResponse($data = json_encode(['data' => ['field' => 'value']])));
        $response = $fakeQuery->request(Request::METHOD_GET, '/toto');

        //when
        $fixtureClient->setFixture(
            Request::METHOD_GET,
            '/toto',
            $hash = 'hash',
            $response
        );
        $response = $fixtureClient->getFixture(Request::METHOD_GET, '/toto', [
            'query' => $hash
        ]);

        //then
        static::assertTrue($cache->hasItem('GET__toto_hash'));
        static::assertSame($data, $response->getContent());

    }

}
