<?php

namespace AlloCine\GraphClient\Tests\Bundle\Client;

use AlloCine\GraphClient\Bundle\Client\GraphApiBridge;
use AlloCine\GraphClient\Bundle\Client\GraphApiLogger;
use AlloCine\GraphClient\Bundle\Client\GraphClientFixturesMiddleware;
use AlloCine\GraphClient\Bundle\Client\GraphCoverage;
use AlloCine\GraphClient\Bundle\Sanitizer\RedisKeySanitizer;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Cache\Adapter\ArrayAdapter;
use Symfony\Component\Cache\Adapter\NullAdapter;
use Symfony\Component\HttpClient\MockHttpClient;
use Symfony\Component\HttpClient\Response\MockResponse;
use Symfony\Component\HttpFoundation\Request;

class GraphClientBridgeTest extends TestCase
{

    public function testNormalFunctionning(): void
    {
        //given
        $bridge = new GraphApiBridge(
            new MockHttpClient(new MockResponse(json_encode(['data' => ['field' => $value = 'value']]))),
            $this->createMock(GraphApiLogger::class),
            new GraphCoverage(false, 0, 0),
            $this->createMock(GraphClientFixturesMiddleware::class),
            false,
            'http://useless.com'
        );


        //when
        $result = $bridge->query(
            'query body',
            'hash',
        );

        //then
        static::assertSame($value, $result->field);

    }

    public function testFixtureFunctionningWithRecord(): void
    {
        //given
        $bridge = new GraphApiBridge(
            new MockHttpClient(new MockResponse(json_encode(['data' => ['field' => $value = 'value']]))),
            $this->createMock(GraphApiLogger::class),
            new GraphCoverage(false, 0, 0),
            new GraphClientFixturesMiddleware(new NullAdapter(), 'htttp://fixtures_dir', '', 'record'),
            true,
            'http://useless.com'
        );


        //when
        $result = $bridge->query(
            'query body',
            'hash',
        );

        //then
        static::assertSame($value, $result->field);

    }

    public function testFixtureFunctionningWithReplay(): void
    {
        //given
        $bridge = new GraphApiBridge(

            new MockHttpClient(new MockResponse($data = json_encode(['data' => ['field' => 'value']]))),
            $this->createMock(GraphApiLogger::class),
            new GraphCoverage(false, 0, 0),
            new GraphClientFixturesMiddleware($cache = new ArrayAdapter(), 'htttp://fixtures_dir', '', 'replay'),
            true,

            $apiUri = 'http://useless.com'
        );

        //insert fixture in cache
        $item = $cache->getItem(RedisKeySanitizer::sanitize(Request::METHOD_POST . '_' . $apiUri . '_' . ($hash = 'hash')));
        $item->set($data);
        $cache->save($item);


        //when
        $result = $bridge->query(
            'query body',
            $hash
        );

        //then
        static::assertSame(json_decode($data)->data->field, $result->field);

    }

}