<?php

namespace AlloCine\GraphClient\Bundle\Cache\Adapter;

use AlloCine\GraphClient\Bundle\Sanitizer\RedisKeySanitizer;
use Symfony\Component\Cache\Adapter\FilesystemAdapter;
use Symfony\Component\Cache\Marshaller\MarshallerInterface;

class SanitizeFilesystemAdapter extends FilesystemAdapter
{
    public function __construct(string $namespace = '', int $defaultLifetime = 0, ?string $directory = null, ?MarshallerInterface $marshaller = null)
    {
        parent::__construct(RedisKeySanitizer::sanitize($namespace), $defaultLifetime, $directory, $marshaller);
    }

}