<?php

namespace Tests\AlloCine\GraphClient\CoverageChecker\Checker;

use AlloCine\GraphClient\CoverageChecker\ArrayWrapper;
use AlloCine\GraphClient\CoverageChecker\Checker\RelativeChecker;
use PHPUnit\Framework\TestCase;

class RelativeCheckerTest extends TestCase
{
    public function testCheck()
    {
        $wrapper = $this->getWrapper();
        $checker = new RelativeChecker();

        $wrapper['foobar'];

        $errors = $checker->check($wrapper);

        $this->assertSame(3, count($errors));
        $this->assertSame('Array at path "foo.bar" has a too low coverage ratio (0%).', $errors[0]->getMessage());
        $this->assertSame('Array at path "foo" has a too low coverage ratio (0%).', $errors[1]->getMessage());
        $this->assertSame('Root array has a too low coverage ratio (28%).', $errors[2]->getMessage());
    }

    public function testRootCheck()
    {
        $wrapper = $this->getWrapper();
        $checker = new RelativeChecker();

        $wrapper['foo']['bar'][0];

        $errors = $checker->check($wrapper);
        $this->assertSame(1, count($errors));
        $this->assertSame('Root array has a too low coverage ratio (71%).', $errors[0]->getMessage());
    }

    public function testThreshold()
    {
        $wrapper = $this->getWrapper();
        $checker = new RelativeChecker(70);

        $wrapper['foo']['bar'][0];

        $errors = $checker->check($wrapper);

        $this->assertSame(0, count($errors));
    }

    public function testCheckObject()
    {
        $wrapper = $this->getWrapperObject();
        $checker = new RelativeChecker();

        $wrapper->foobar;

        $errors = $checker->check($wrapper);

        $this->assertSame(3, count($errors));
        $this->assertSame('Array at path "foo.bar" has a too low coverage ratio (0%).', $errors[0]->getMessage());
        $this->assertSame('Array at path "foo" has a too low coverage ratio (0%).', $errors[1]->getMessage());
        $this->assertSame('Root array has a too low coverage ratio (28%).', $errors[2]->getMessage());
    }

    public function testRootCheckObject()
    {
        $wrapper = $this->getWrapperObject();
        $checker = new RelativeChecker();

        $wrapper->foo->bar[0];

        $errors = $checker->check($wrapper);
        $this->assertSame(1, count($errors));
        $this->assertSame('Root array has a too low coverage ratio (71%).', $errors[0]->getMessage());
    }

    public function testThresholdObject()
    {
        $wrapper = $this->getWrapperObject();
        $checker = new RelativeChecker(70);

        $wrapper->foo->bar[0];

        $errors = $checker->check($wrapper);

        $this->assertSame(0, count($errors));
    }

    /**
     * @return ArrayWrapper
     */
    private function getWrapper(): ArrayWrapper
    {
        return new ArrayWrapper([
            'foo' => [
                'bar' => ['baz']
            ],
            'foobar' => 1
        ]);
    }

    /**
     * @return ArrayWrapper
     */
    private function getWrapperObject(): ArrayWrapper
    {
        $bar = new \stdClass();
        $bar->bar = ['baz'];
        $foo = new \stdClass();
        $foo->foo = $bar;
        $foo->foobar = 1;

        return new ArrayWrapper($foo);
    }
}
