<?php

namespace Tests\AlloCine\GraphClient\Bundle\Parser;

use AlloCine\GraphClient\Bundle\Parser\QueryParser;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Finder\Finder;
use Symfony\Component\Finder\SplFileInfo;

class QueryParserTest extends TestCase
{
    /**
     * @var array
     */
    private $sources = [
        'queries' => __DIR__ . '/../Resources/graph/queries/',
        'fragments' => __DIR__ . '/../Resources/graph/fragments/',
    ];

    /**
     * @var array
     */
    private $queries;

    /**
     * @var array
     */
    private $fragments;

    /**
     * @throws \Exception|@throws \FileNotFoundException
     */
    public function setUp(): void
    {
        $this->init();
    }

    /**
     * @throws \Exception|\FileNotFoundException
     */
    public function testParseQueryWith2Fragments()
    {
        $service = new QueryParser();
        $query =
            <<<GRAPHQL
{
    testTwoReal (test: 10){
        ...realFragment
        ...realFragment
    }
}
GRAPHQL;
        $result = $service->setFragments($this->fragments)->parseQuery($query);
        $this->assertSame($query . ' ' . $this->fragments['realFragment'], $result);

    }

    /**
     * @throws \Exception|\FileNotFoundException
     */
    public function testParseQueryReal()
    {
        $service = new QueryParser();
        $result = $service->setFragments($this->fragments)->parseQuery($this->queries['testReal']);
        $this->assertSame($this->queries['testReal'], $result);

    }

    /**
     * @throws \Exception|\FileNotFoundException
     */
    private function init()
    {
        $this->storedQueries('queries');
        $this->storedQueries('fragments');
    }

    /**
     * @param string $arrayName
     */
    private function storedQueries(string $arrayName)
    {
        $finder = new Finder();
        $templates = $finder->files()->in($this->sources[$arrayName]);
        $extension = str_replace('.', '', 'graphql');
        /** @var SplFileInfo $template */
        foreach ($templates as $template) {
            if ($template->getExtension() === $extension) {
                $fragmentName = str_replace('.graphql', '', $template->getFilename());
                $this->$arrayName[$fragmentName] = $template->getContents();
            }
        }
    }
}
