<?php

namespace AlloCine\GraphClient\CoverageChecker;

class Usage
{
    /**
     * @var bool
     */
    private $used;

    /**
     * @var int
     */
    private $weight;

    /**
     * @param mixed $source
     */
    public function __construct($source)
    {
        $this->weight = strlen(serialize($source));
        $this->used = false;
    }

    public function markUsed()
    {
        $this->used = true;
    }

    /**
     * @return bool
     */
    public function isUsed(): bool
    {
        return $this->used;
    }

    /**
     * @return int
     */
    public function getWeight(): int
    {
        return $this->weight;
    }
}
