<?php

namespace AlloCine\GraphClient\CoverageChecker\Checker;

use AlloCine\GraphClient\CoverageChecker\ArrayWrapper;
use AlloCine\GraphClient\CoverageChecker\Error\CoverageError;

class AbsoluteChecker extends Checker
{
    /**
     * @var int
     */
    private $threshold;

    /**
     * @param int|integer $threshold
     */
    public function __construct(int $threshold = 0)
    {
        $this->threshold = $threshold;
    }

    /**
     * @param ArrayWrapper $wrapper
     *
     * @return int
     */
    public function getValue(ArrayWrapper $wrapper): int
    {
        return $wrapper->getCoverage()['uncovered'];
    }

    /**
     * {@inheritdoc}
     */
    public function check(ArrayWrapper $wrapper): array
    {
        $errors = [];

        $wrapper->silkTouchIterate(function ($item) use (&$errors) {
            if (!($item instanceof ArrayWrapper)) {
                return;
            }

            $errors = array_merge($errors, $this->check($item));
        });

        $coverage = $wrapper->getCoverage();

        if ($coverage['uncovered'] > $this->threshold) {
            $errors[]=CoverageError::tooMuchUncovered($wrapper, $coverage['uncovered']);
        }

        return $errors;
    }
}
