<?php

declare(strict_types=1);

namespace AlloCine\GraphClient\CoverageChecker;

class Usage
{
    private bool $used = false;

    private readonly int $weight;

    public function __construct(mixed $source)
    {
        $this->weight = strlen(serialize($source));
    }

    public function markUsed(): void
    {
        $this->used = true;
    }

    public function isUsed(): bool
    {
        return $this->used;
    }

    public function getWeight(): int
    {
        return $this->weight;
    }
}
