<?php

namespace AlloCine\GraphClient\CoverageChecker\Checker;

use AlloCine\GraphClient\CoverageChecker\ArrayWrapper;
use AlloCine\GraphClient\CoverageChecker\Error\CoverageError;

class RelativeChecker extends Checker
{
    /**
     * @var int
     */
    private $threshold;

    /**
     * @param int|integer $threshold
     */
    public function __construct(int $threshold = 100)
    {
        $this->threshold = $threshold;
    }

    /**
     * @param ArrayWrapper $wrapper
     *
     * @return int
     */
    public function getValue(ArrayWrapper $wrapper): int
    {
        $coverage = $wrapper->getCoverage();

        return 100 * $coverage['covered'] / ($coverage['uncovered'] + $coverage['covered']);
    }

    /**
     * {@inheritdoc}
     */
    public function check(ArrayWrapper $wrapper): array
    {
        $errors = [];

        $wrapper->silkTouchIterate(function ($item) use (&$errors) {
            if (!($item instanceof ArrayWrapper)) {
                return;
            }

            $errors = array_merge($errors, $this->check($item));
        });

        $coverage = $wrapper->getCoverage();
        $coveredRatio = 100 * $coverage['covered'] / ($coverage['uncovered'] + $coverage['covered']);

        if ($coveredRatio < $this->threshold) {
            $errors[]=CoverageError::lowCoverageRatio($wrapper, $coveredRatio);
        }

        return $errors;
    }
}
