<?php

namespace AlloCine\GraphClient\Bundle\Client;

class GraphCursor
{
    const CURSOR_INTERNAL_PREFIX = 'arrayconnection';

    /**
     * Given an offset in a list, returns the cursor to use as a value for
     * the graph "after" argument to paginate from this offset.
     *
     * @param int $cursor
     * @param int $offset
     *
     * @return null|string
     */
    public function getAfterCursor(int $cursor, int $offset = 0)
    {
        if ($cursor + $offset <= 1) {
            return null;
        }

        return $this->encodeCursor($cursor - 1 + $offset);
    }

    /**
     * @param int $position
     *
     * @return string
     */
    private function encodeCursor(int $position): string
    {
        return base64_encode(sprintf('%s:%d', self::CURSOR_INTERNAL_PREFIX, $position));
    }
}
