<?php

namespace AlloCine\GraphClient\Bundle\Client;

class GraphApiLogger
{
    /**
     * @var bool
     */
    private $enabled;

    /**
     * @var array
     */
    private $storage;

    /**
     * @param bool $enabled
     */
    public function __construct(bool $enabled = true)
    {
        $this->enabled = $enabled;
        $this->storage = [];
    }

    /**
     * @param string $query
     *
     * @return int
     */
    public function start(string $query): int
    {
        if (!$this->enabled) {
            return -1;
        }

        $id = count($this->storage);

        $this->storage[$id] = ['query' => json_decode($query), 'start_time' => microtime(true)];

        return $id;
    }

    /**
     * @param int    $id
     * @param string $result
     */
    public function stop(int $id, string $result)
    {
        if (!$this->enabled) {
            return;
        }

        $result = json_decode($result);

        $this->storage[$id]['end_time'] = microtime(true);
        $this->storage[$id]['duration'] = $this->storage[$id]['end_time'] - $this->storage[$id]['start_time'];
        $this->storage[$id]['complexity'] = $result->extensions->complexity ?? null;
        unset($result->extensions->complexity);
        $this->storage[$id]['result'] = $result;
        $this->storage[$id]['payload'] = isset($result->data) ? strlen(json_encode($result->data))/1024 : 0;
    }

    /**
     * @return array
     */
    public function getAll(): array
    {
        return array_values($this->storage);
    }

    /**
     * @return bool
     */
    public function isEnabled(): bool
    {
        return $this->enabled;
    }
}
