<?php

namespace AlloCine\DoctrineCacheRediscluster\Cache;

use Csa\GuzzleHttp\Middleware\Cache\Adapter\DoctrineAdapter;
use Csa\GuzzleHttp\Middleware\Cache\Adapter\StorageAdapterInterface;
use function GuzzleHttp\Psr7\modify_request;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;

/**
 * Deleting the user-agent header to avoid hyper-variability of requests
 */
class CacheAdapter extends DoctrineAdapter implements StorageAdapterInterface
{

    /**
     * {@inheritdoc}
     */
    public function fetch(RequestInterface $request)
    {
        $request = modify_request($request, ['remove_headers' => ['User-Agent']]);
        return parent::fetch($request);
    }

    /**
     * @param RequestInterface  $request
     * @param ResponseInterface $response
     */
    public function save(RequestInterface $request, ResponseInterface $response)
    {
        $statusCode = $response->getStatusCode() ;

        if ($statusCode >= 200 && $statusCode < 300) {
            $request = modify_request($request, ['remove_headers' => ['User-Agent']]);
            parent::save($request, $response);
        }
    }
}
